<?php

namespace App\Filament\Clusters\Business\Resources\BusinessUnits\Schemas;

use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;

class BusinessUnitForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('name')
                    ->label('Nama Unit Usaha')
                    ->placeholder('Nama Unit Usaha')
                    ->required()
                    ->maxLength(255),

                Select::make('business_type_id')
                    ->relationship('businessType', 'name')
                    ->label('Jenis Usaha')
                    ->searchable()
                    ->preload()
                    ->required(),

                Textarea::make('business_description')
                    ->label('Deskripsi')
                    ->placeholder('Toko yang menjual kebutuhan sehari-hari masyarakat.')
                    ->rows(3)
                    ->columnSpanFull(),

                TextInput::make('initial_capital')
                    ->label('Modal Awal')
                    ->numeric()
                    ->prefix('Rp')
                    ->default(0)
                    ->required(),

                DatePicker::make('start_date')
                    ->label('Tanggal Mulai')
                    ->required(),
            ]);
    }
}
