<?php

namespace App\Filament\Clusters\Business\Resources\BusinessUnits\Pages;

use App\Filament\Clusters\Business\Resources\BusinessUnits\BusinessUnitResource;
use App\Models\Business;
use Filament\Actions\CreateAction;
use Filament\Resources\Pages\ListRecords;

class ListBusinessUnits extends ListRecords
{
    protected static string $resource = BusinessUnitResource::class;

    protected function getHeaderActions(): array
    {
        return [
            CreateAction::make()
                ->icon('heroicon-o-plus')
                ->label('Unit Usaha')
                ->modalHeading('Buat Unit Usaha Baru')
                ->successNotificationTitle('Unit Usaha Berhasil Ditambahkan')
                ->disabled(function () {
                    // Kalau belum ada BUMDes di tenant ini, tombol Add di-disable
                    return ! Business::where('team_id', filament()->getTenant()->id)->exists();
                })
        ];
    }
}
