# 🏡 SIDA – Sistem Informasi Desa

**SIDA (Sistem Informasi Desa)** adalah aplikasi web yang membantu pemerintah desa dalam mengelola data wilayah, penduduk, administrasi surat, keuangan RT, serta layanan publik secara digital dan transparan.  
Dibangun menggunakan **Laravel** dan **FilamentPHP**, SIDA menghadirkan antarmuka yang modern, cepat, dan mudah digunakan oleh perangkat desa.

---

## 🚀 Fitur Utama

### 📊 **Dasbor**

Menampilkan ringkasan informasi penting desa secara real-time, termasuk jumlah penduduk, laporan keuangan RT, kegiatan, dan aduan warga.

### 🗺️ **Wilayah**

Manajemen data wilayah administrasi desa seperti dusun, RW, dan RT untuk struktur organisasi yang lebih teratur.

### 🧍‍♂️ **Kependudukan**

Pengelolaan data penduduk dan keluarga:

-   Data individu dan KK
-   Mutasi penduduk (masuk & keluar)
-   Pencatatan status keluarga

### 📄 **Surat**

Modul administrasi surat dengan tiga subfitur utama:

-   ✉️ **Permohonan Surat** – warga dapat mengajukan permohonan surat secara online atau oleh operator desa.
-   📥 **Surat Masuk** – pencatatan surat resmi yang diterima oleh desa.
-   📤 **Surat Keluar** – pengarsipan surat yang dikeluarkan desa, lengkap dengan nomor surat dan QR code verifikasi.

### 💰 **Keuangan RT**

Pencatatan transaksi keuangan di tingkat RT:

-   Pemasukan dan pengeluaran
-   Laporan rekap per RT
-   Transparansi dan akuntabilitas dana

### 📢 **Aduan Warga**

Fitur bagi warga untuk menyampaikan keluhan, laporan, atau saran kepada perangkat desa secara langsung dan terdokumentasi.

### 🎁 **Bantuan Sosial**

Pendataan dan pemantauan program bantuan sosial desa:

-   Daftar penerima manfaat
-   Jenis bantuan dan jadwal penyaluran
-   Riwayat distribusi bantuan

### 🏠 **Bangunan**

Pendataan aset dan infrastruktur desa:

-   Fasilitas umum, kantor, sekolah, rumah ibadah, dll
-   Data kondisi dan lokasi bangunan

### 🏢 **BUMDes**

Modul manajemen **Badan Usaha Milik Desa**:

-   Data unit usaha
-   Laporan kegiatan dan pendapatan
-   Aset dan keuangan BUMDes

### 👥 **User & Role**

Manajemen pengguna sistem dengan pengaturan hak akses:

-   Admin Desa
-   Operator / Sekretaris
-   Ketua RT / RW
-   Pengguna publik (akses terbatas)

---

## 🧩 Fitur yang Akan Datang

-   🌐 **Web Portal Desa** – portal publik untuk berita, agenda, dan profil desa.
-   💸 **Keuangan Desa Terpusat** – integrasi keuangan dari seluruh RT ke sistem desa utama.

---

## 🛠️ Teknologi yang Digunakan

-   **Framework:** Laravel 12
-   **Admin Panel:** FilamentPHP
-   **Frontend:** TailwindCSS
-   **Database:** MySQL / MariaDB
-   **Autentikasi:** Filament Auth
